/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.payroll.dto.MKintaiKeisanDto;

public class AttendanceCalculateEndCardVo extends AttendanceCalculateMenuVo {

	private static final long serialVersionUID = 1473050564230241352L;

	// URL
	private static final String RETURN_URL = "/jsp/payroll/attendanceCalculateEndCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/attendanceCalculateEndCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/attendanceCalculateEndCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ATT_CALCULATE_END;

	// 萔
	public static final int MODE_UPDATE 		= 0;
	public static final int MODE_IMPOSSIBLE 	= 1;

	// p[^

	// tB[h
	private String lblKTnen;
	private String lblKTtuki;

	// [h(0FXVA1Fs)
	private int mode;

	// tB[hyѐ
	public static final String NAM_KT_YYMM_NAME = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_YEAR + CommonConst.NAM_MONTH;

	public static final int	LEN_NEN		= CommonConst.LEN_YEAR;
	public static final int	LEN_TUKI	= CommonConst.LEN_MONTH_DAY;

	/**
	 * RXgN^
	 */
	public AttendanceCalculateEndCardVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		mode = MODE_UPDATE;
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setLblKTnen("");
		setLblKTtuki("");
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MKintaiKeisanDto dto) {
		lblKTnen 	= String.valueOf(dto.getKTNen());
		lblKTtuki 	= String.valueOf(dto.getKTTuki());
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getEscLblKTnen() 		{ return escapeHTML(lblKTnen)	; }
	public String getEscLblKTtuki() 	{ return escapeHTML(lblKTtuki)	; }

	public void setLblKTnen	(String lblKTnen	) { this.lblKTnen 	= lblKTnen	; }
	public void setLblKTtuki	(String lblKTtuki	) { this.lblKTtuki 	= lblKTtuki	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
